/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.log;

import dm.jdbc.filter.log.Logger;

class LogRecord {
    public static final NullData NULL = new NullData();
    public String source;
    public String method;
    public Object[] params;
    public Object returnValue;
    public Throwable e;
    public long usedTime;
    public long startTime;
    public long endTime;
    public String sql;

    public LogRecord(Object source, String method, Object ... params) {
        this.source = Logger.formatSource(source);
        this.method = method;
        this.params = params;
        this.startTime = System.nanoTime();
    }

    public String toString() {
        StringBuilder str = new StringBuilder(128);
        str.append(Logger.formatTrace((Object)this.source, this.method, this.returnValue, this.params));
        if (this.usedTime > 0L) {
            str.append(this.formatUsedTime(this.usedTime));
        } else {
            str.append(this.formatUsedTime(this.endTime - this.startTime));
        }
        return str.toString();
    }

    private String formatUsedTime(long nano) {
        return "[USED TIME]: " + (double)nano / 1000000.0 + "ms;";
    }

    public void setThrowable(Throwable e2) {
        this.e = e2;
    }

    public Throwable getThrowable() {
        return this.e;
    }

    public void setReturnValue(Object retValue) {
        this.returnValue = retValue == null ? NULL : retValue;
    }

    public Object getReturnValue() {
        return this.returnValue;
    }

    public void setUsedTime(long usedTime) {
        this.usedTime = usedTime;
    }

    public long getUsedTime() {
        return this.usedTime;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    static class NullData {
        NullData() {
        }
    }
}

