/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.a.b;

import dm.jdbc.a.b.a;
import dm.jdbc.dbaccess.DmCipherEncryptDLL;
import dm.jdbc.driver.DBError;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.StringUtil;
import java.security.MessageDigest;
import java.sql.SQLException;
import java.util.Arrays;

public class h
extends a {
    private int g;
    private byte[] eQ;
    private int dT;
    private int eH;

    public h(int encryptType, byte[] sessionKey, String cipherPath, int hashType) throws SQLException {
        if (StringUtil.isNotEmpty(cipherPath) && DmCipherEncryptDLL.initCipherEncrypt(cipherPath) <= 0) {
            DBError.ECJDBC_NEGOTIATE_FAIL.throwz(new Object[0]);
        }
        this.g = encryptType;
        this.eQ = sessionKey;
        this.dT = hashType;
        int n2 = this.eH = hashType == 4352 ? 16 : DmCipherEncryptDLL.getHashSize(hashType);
        if (this.eH < 0) {
            DBError.ECJDBC_NEGOTIATE_FAIL.throwz(new Object[0]);
        }
    }

    @Override
    public byte[] a(byte[] byteSource, int offset, int len, boolean genDigest) throws SQLException {
        byte[] ret;
        byte[] src = byteSource;
        if (offset != 0 || len != byteSource.length) {
            src = new byte[len];
            ByteUtil.setBytes(src, 0, byteSource, offset, len);
        }
        if ((ret = DmCipherEncryptDLL.cipherEncrypt(this.g, this.eQ, src)) == null) {
            DBError.ECJDBC_MESSAGE_ENCRYPT_FAIL.throwz(new Object[0]);
        }
        if (genDigest) {
            byte[] digest = this.a(this.dT, src);
            byte[] encrypt = ret;
            ret = new byte[ret.length + digest.length];
            System.arraycopy(encrypt, 0, ret, 0, encrypt.length);
            System.arraycopy(digest, 0, ret, encrypt.length, digest.length);
        }
        return ret;
    }

    private byte[] a(int algorithm, byte[] msg_text) {
        byte[] msg_digest = null;
        switch (algorithm) {
            case 4352: {
                try {
                    MessageDigest md = MessageDigest.getInstance("MD5");
                    md.reset();
                    md.update(msg_text);
                    msg_digest = md.digest();
                }
                catch (Exception e2) {
                    DBError.throwRuntimeException("error digest type", e2);
                }
                break;
            }
            default: {
                msg_digest = DmCipherEncryptDLL.cipherHash(algorithm, msg_text);
            }
        }
        if (msg_digest == null || msg_digest.length == 0 || msg_digest.length == 1 && msg_digest[0] == 0) {
            DBError.throwRuntimeException("get message digest fail");
        }
        return msg_digest;
    }

    @Override
    public byte[] b(byte[] byteSource, int offset, int len, boolean checkDigest) throws SQLException {
        byte[] ret = null;
        if (checkDigest) {
            byte[] digest = new byte[this.eH];
            System.arraycopy(byteSource, offset + len - this.eH, digest, 0, this.eH);
            ret = new byte[len - this.eH];
            System.arraycopy(byteSource, offset, ret, 0, len - this.eH);
            ret = DmCipherEncryptDLL.cipherDecrypt(this.g, this.eQ, ret);
            byte[] msg_digest = this.a(this.dT, ret);
            if (!Arrays.equals(msg_digest, digest)) {
                DBError.ECJDBC_MESSAGE_DECRYPT_FAIL.throwz(new Object[0]);
            }
        } else {
            byte[] src = byteSource;
            if (offset != 0 || len != byteSource.length) {
                src = new byte[len];
                ByteUtil.setBytes(src, 0, byteSource, offset, len);
            }
            ret = DmCipherEncryptDLL.cipherDecrypt(this.g, this.eQ, src);
        }
        if (ret == null) {
            DBError.ECJDBC_MESSAGE_DECRYPT_FAIL.throwz(new Object[0]);
        }
        return ret;
    }
}

