/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.desc.Column;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbInputStream;
import dm.jdbc.driver.DmdbOutputStream;
import dm.jdbc.internal.AbstractLob;
import dm.jdbc.util.ByteUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicLong;

public class DmdbBlob
extends AbstractLob
implements Blob {
    public byte[] data;
    public static AtomicLong IDGenerator = new AtomicLong(0L);

    @Override
    public long getID() {
        if (this.ID < 0L) {
            this.ID = IDGenerator.incrementAndGet();
        }
        return this.ID;
    }

    private DmdbBlob(byte[] value, DmdbConnection conn, Column column, boolean fetchAll) throws SQLException {
        super(value, (byte)0, conn, column);
        this.length = this.bytesLength;
        if (this.storageType == 1) {
            int headSize = this.getHeadSize();
            this.data = new byte[(int)this.length];
            ByteUtil.setBytes(this.data, 0, value, headSize, this.data.length);
        } else if (fetchAll) {
            this.loadAllData();
        }
    }

    private DmdbBlob(byte[] data, DmdbConnection connection) {
        super((byte)0, connection);
        this.data = data;
        this.length = this.data.length;
    }

    public static DmdbBlob newInstanceFromDB(byte[] value, DmdbConnection conn, Column column, boolean fetchAll) throws SQLException {
        return new DmdbBlob(value, conn, column, fetchAll);
    }

    public static DmdbBlob newInstanceOfLocal(byte[] data, DmdbConnection connection) {
        return new DmdbBlob(data, connection);
    }

    public static DmdbBlob getEmptyBlob() {
        try {
            DmdbBlob blob = new DmdbBlob(new byte[0], new DmdbConnection(null));
            blob.empty = true;
            return blob;
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public byte[] do_getBytes(long pos, int len) throws SQLException {
        long leaveLength;
        this.checkFreed();
        if (pos < 1L || len < 0) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
        }
        if ((leaveLength = this.do_length() - --pos) < 0L) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
        }
        len = (int)((long)len > leaveLength ? leaveLength : (long)len);
        if (this.local || this.storageType == 1 || this.fetchAll) {
            byte[] buf = new byte[len];
            ByteUtil.setBytes(buf, 0, this.data, (int)pos, buf.length);
            return buf;
        }
        this.connection.checkClosed();
        return this.connection.dbAccess.a(this, pos, len);
    }

    public DmdbInputStream do_getBinaryStream() throws SQLException {
        this.checkFreed();
        return new DmdbInputStream(this, 1);
    }

    public long do_position(byte[] pattern, long start) throws SQLException {
        this.checkFreed();
        if (start < 1L) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
        }
        if (pattern == null || pattern.length == 0) {
            return -1L;
        }
        byte[] bs = this.do_getBytes(start, (int)this.do_length());
        if (bs == null || bs.length == 0) {
            return -1L;
        }
        long ret = ByteUtil.indexOf(bs, pattern);
        if (ret >= 0L) {
            ++ret;
        }
        return ret;
    }

    public long do_position(Blob pattern, long start) throws SQLException {
        return this.do_position(pattern.getBytes(1L, (int)pattern.length()), start);
    }

    public int do_setBytes(long pos, byte[] bytes) throws SQLException {
        return this.do_setBytes(pos, bytes, 0, bytes.length);
    }

    public int do_setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        this.checkFreed();
        if (pos < 1L || len < 0 || offset < 0) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
        }
        if (!this.updateable) {
            DBError.ECJDBC_RESULTSET_IS_READ_ONLY.throwz(new Object[0]);
        }
        len = offset + len > bytes.length ? bytes.length - offset : len;
        --pos;
        int retlen = 0;
        if (this.local || this.fetchAll) {
            if (pos > this.do_length()) {
                DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
            }
            this.setLocalData((int)pos, bytes, offset, len);
            retlen = len;
        } else {
            this.connection.checkClosed();
            int writeLen = this.connection.dbAccess.a(this, pos, bytes, offset, len);
            if (this.storageType == 1) {
                this.setLocalData((int)pos, bytes, offset, writeLen);
            }
            retlen = writeLen;
        }
        this.modify = true;
        return retlen;
    }

    public DmdbOutputStream do_setBinaryStream(long pos) throws SQLException {
        this.checkFreed();
        if (this.connection.compatibleOracle() && pos == 0L) {
            pos = 1L;
        }
        if (pos < 1L) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
        }
        return new DmdbOutputStream(this, pos, 1);
    }

    @Deprecated
    public DmdbOutputStream getBinaryOutputStream() throws SQLException {
        return this.do_setBinaryStream(1L);
    }

    @Deprecated
    public DmdbOutputStream getBinaryOutputStream(long pos) throws SQLException {
        return this.do_setBinaryStream(pos);
    }

    public void do_truncate(long len) throws SQLException {
        this.checkFreed();
        if (len < 0L) {
            DBError.ECJDBC_INVALID_LENGTH_OR_OFFSET.throwz(new Object[0]);
        }
        if (!this.updateable) {
            DBError.ECJDBC_RESULTSET_IS_READ_ONLY.throwz(new Object[0]);
        }
        if (this.local || this.fetchAll) {
            if (len >= (long)this.data.length) {
                return;
            }
            byte[] tmp = new byte[(int)len];
            ByteUtil.setBytes(tmp, 0, this.data, 0, tmp.length);
            this.data = tmp;
            this.length = tmp.length;
        } else {
            this.connection.checkClosed();
            this.length = this.connection.dbAccess.a(this, len);
            if (this.storageType == 1) {
                byte[] tmp = new byte[(int)this.do_length()];
                ByteUtil.setBytes(tmp, 0, this.data, 0, tmp.length);
                this.data = tmp;
            }
        }
        this.modify = true;
    }

    @Override
    public void do_free() throws SQLException {
        super.do_free();
        this.data = null;
    }

    public DmdbInputStream do_getBinaryStream(long pos, long length) throws SQLException {
        this.checkFreed();
        return new DmdbInputStream(this, pos, length);
    }

    @Override
    protected void loadAllData() throws SQLException {
        this.checkFreed();
        if (this.local || this.storageType == 1 || this.fetchAll) {
            return;
        }
        this.data = this.do_getBytes(1L, (int)this.do_length());
        this.fetchAll = true;
    }

    private void setLocalData(int pos, byte[] bytes, int offset, int len) {
        if ((long)(pos + len) > this.length) {
            byte[] tmp = new byte[pos + len];
            ByteUtil.setBytes(tmp, 0, this.data, 0, pos);
            ByteUtil.setBytes(tmp, pos, bytes, offset, len);
            this.data = tmp;
        } else {
            ByteUtil.setBytes(this.data, pos, bytes, offset, len);
        }
        this.length = this.data.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public long length() throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_length();
            }
            return this.filterChain.reset().Blob_length(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public byte[] getBytes(long pos, int length) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getBytes(pos, length);
            }
            return this.filterChain.reset().Blob_getBytes(this, pos, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public InputStream getBinaryStream() throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getBinaryStream();
            }
            return this.filterChain.reset().Blob_getBinaryStream(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public long position(byte[] pattern, long start) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_position(pattern, start);
            }
            return this.filterChain.reset().Blob_position(this, pattern, start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public long position(Blob pattern, long start) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_position(pattern, start);
            }
            return this.filterChain.reset().Blob_position(this, pattern, start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_setBytes(pos, bytes);
            }
            return this.filterChain.reset().Blob_setBytes(this, pos, bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_setBytes(pos, bytes, offset, len);
            }
            return this.filterChain.reset().Blob_setBytes(this, pos, bytes, offset, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public OutputStream setBinaryStream(long pos) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_setBinaryStream(pos);
            }
            return this.filterChain.reset().Blob_setBinaryStream(this, pos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void truncate(long len) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_truncate(len);
            } else {
                this.filterChain.reset().Blob_truncate(this, len);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void free() throws SQLException {
        if (this.connection == null) {
            return;
        }
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                this.do_free();
            } else {
                this.filterChain.reset().Blob_free(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        this.checkConnection();
        DmdbConnection dmdbConnection = this.connection;
        synchronized (dmdbConnection) {
            if (this.filterChain == null) {
                return this.do_getBinaryStream(pos, length);
            }
            return this.filterChain.reset().Blob_getBinaryStream(this, pos, length);
        }
    }
}

