/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.rw;

import dm.jdbc.desc.conf.DmProperties;
import dm.jdbc.desc.enums.RWSite;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.util.MathUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;

public class RWCounter {
    private static Boolean rwMapMutex = new Boolean(true);
    private static HashMap<String, RWCounter> rwMap = new HashMap();
    private int standbyCount;
    private int primaryIncrement;
    private int standbyIncrement;
    private double primaryPercent = 0.0;
    private double standbyPercent = 0.0;
    private EPCounter primaryCounter;
    private EPCounter standbysCounter;
    private HashMap<String, EPCounter> standbyMap;
    private Random standbyChooser = new Random();

    private RWCounter(int primaryPercent, int standbyCount) {
        this.reset(primaryPercent, standbyCount);
    }

    private synchronized void reset(int primaryPercent, int standbyCount) {
        this.standbyCount = standbyCount;
        int[] increments = new int[standbyCount + 1];
        increments[0] = primaryPercent * standbyCount;
        Arrays.fill(increments, 1, increments.length, 100 - primaryPercent);
        increments = MathUtil.divis(increments);
        this.primaryIncrement = increments[0];
        int n2 = this.standbyIncrement = standbyCount > 0 ? increments[1] : 0;
        if (standbyCount > 0) {
            this.primaryPercent = (double)primaryPercent / 100.0;
            this.standbyPercent = (double)(100 - primaryPercent) / 100.0 / (double)standbyCount;
        } else {
            this.primaryPercent = 1.0;
            this.standbyPercent = 0.0;
        }
        this.primaryCounter = new EPCounter();
        this.primaryCounter.balance = this.primaryIncrement;
        this.standbysCounter = new EPCounter();
        this.standbysCounter.balance = this.standbyIncrement * standbyCount;
        this.standbyMap = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RWCounter getInstance(DmdbConnection connection, int standbyCount) {
        String key = String.valueOf(connection.host) + "_" + connection.port + "_" + connection.rwPercent;
        RWCounter rwCounter = null;
        Boolean bl = rwMapMutex;
        synchronized (bl) {
            rwCounter = rwMap.get(key);
            if (rwCounter == null) {
                rwCounter = new RWCounter(connection.rwPercent, standbyCount);
                rwMap.put(key, rwCounter);
            } else if (standbyCount != rwCounter.standbyCount) {
                rwCounter.reset(connection.rwPercent, standbyCount);
            }
        }
        return rwCounter;
    }

    public synchronized RWSite countPrimary() {
        this.adjustNtrx();
        this.primaryCounter.incrementNtrx();
        return RWSite.PRIMARY;
    }

    public synchronized RWSite countStandby() {
        this.adjustNtrx();
        this.standbysCounter.incrementNtrx();
        return RWSite.STANDBY;
    }

    public synchronized RWSite count(RWSite dest, DmdbConnection standby) {
        this.adjustNtrx();
        switch (dest) {
            case ANY: {
                if (this.primaryPercent == 1.0 || this.primaryCounter.balance > this.getStandbyCounter((DmdbConnection)standby).balance && this.primaryCounter.balance > this.standbysCounter.balance) {
                    this.primaryCounter.incrementNtrx();
                    dest = RWSite.PRIMARY;
                    break;
                }
                this.getStandbyCounter(standby).incrementNtrx();
                this.standbysCounter.incrementNtrx();
                dest = RWSite.STANDBY;
                break;
            }
            case STANDBY: {
                this.getStandbyCounter(standby).incrementNtrx();
                this.standbysCounter.incrementNtrx();
                break;
            }
            case PRIMARY: {
                this.primaryCounter.incrementNtrx();
                break;
            }
            default: {
                DBError.throwRuntimeException("Invalid RWSite!");
            }
        }
        return dest;
    }

    private synchronized void adjustNtrx() {
        if (this.primaryCounter.ntrx + this.standbysCounter.ntrx >= Long.MAX_VALUE) {
            long min = 0L;
            for (EPCounter scounter : this.standbyMap.values()) {
                if (scounter.ntrx >= min && min != 0L) continue;
                min = scounter.ntrx;
            }
            min = min < this.primaryCounter.ntrx ? min : this.primaryCounter.ntrx;
            this.primaryCounter.ntrx /= min;
            long standbysNtrx = 0L;
            for (EPCounter scounter : this.standbyMap.values()) {
                scounter.ntrx /= min;
                standbysNtrx += scounter.ntrx;
            }
            this.standbysCounter.ntrx = standbysNtrx;
        }
        if (this.primaryCounter.balance <= 0 && this.standbysCounter.balance <= 0) {
            this.primaryCounter.balance += this.primaryIncrement;
            for (EPCounter scounter : this.standbyMap.values()) {
                scounter.balance += this.standbyIncrement;
            }
        }
    }

    private synchronized EPCounter getStandbyCounter(DmdbConnection standby) {
        String id = String.valueOf(standby.host) + ":" + standby.port;
        EPCounter scounter = this.standbyMap.get(id);
        if (scounter == null) {
            scounter = new EPCounter();
            scounter.balance = this.standbyIncrement;
            scounter.id = id;
            this.standbyMap.put(id, scounter);
        }
        return scounter;
    }

    public int chooseStandbyIndex(int rowCount) {
        return this.standbyChooser.nextInt(rowCount > this.standbyCount ? this.standbyCount : rowCount);
    }

    public String toString() {
        return "PERCENT(P/S) : " + this.primaryPercent + "/" + this.standbyPercent + "\nNTRX_PRIMARY : " + this.primaryCounter.ntrx + "\nNTRX_STANDBY : " + this.standbysCounter.ntrx;
    }

    public static void main(String[] args) throws Exception {
        RWCounter c2 = new RWCounter(20, 2);
        DmdbConnection standby1 = new DmdbConnection(new DmProperties());
        standby1.host = "localhost";
        standby1.port = 7237;
        DmdbConnection standby2 = new DmdbConnection(new DmProperties());
        standby1.host = "localhost";
        standby1.port = 7238;
        RWSite dest = RWSite.ANY;
        Random r2 = new Random();
        while (true) {
            dest = c2.count(RWSite.ANY, r2.nextInt(2) == 1 ? standby1 : standby2);
            if ((c2.primaryCounter.ntrx + c2.standbysCounter.ntrx) % 1000L == 0L) {
                System.out.println("trx count p: " + c2.primaryCounter.ntrx + ", s: " + c2.standbysCounter.ntrx + ", dest: " + (Object)((Object)dest));
                Thread.sleep(1000L);
            }
            if ((c2.primaryCounter.ntrx + c2.standbysCounter.ntrx) % 5000L != 0L) continue;
            c2.reset(20, r2.nextInt(5));
        }
    }

    class EPCounter {
        String id;
        long ntrx;
        int balance;
        boolean isStandby;

        EPCounter() {
        }

        public void incrementNtrx() {
            ++this.ntrx;
            --this.balance;
        }
    }
}

