/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.rw;

import dm.jdbc.desc.conf.DmProperties;
import dm.jdbc.desc.enums.RWSite;
import dm.jdbc.driver.Configuration;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.filter.log.ILogger;
import dm.jdbc.filter.log.LogFactory;
import dm.jdbc.filter.rw.ExecuteCallBack;
import dm.jdbc.filter.rw.RWCounter;
import dm.jdbc.util.MiscUtil;
import dm.jdbc.util.StringUtil;
import java.sql.SQLException;

public class RWUtil {
    private static ILogger log = LogFactory.getLog(RWUtil.class);

    public static DmdbConnection connect(DmDriver driver, DmProperties props) throws SQLException {
        props.setProperty(Configuration.loginMode.getName(), "1");
        DmdbConnection connection = driver.do_connect(props);
        connection.rwInfo.rwCounter = RWCounter.getInstance(connection, connection.standbyCount);
        RWUtil.connectStandby(connection);
        return connection;
    }

    public static void reconnect(DmdbConnection connection) throws SQLException {
        if (connection.rwInfo == null) {
            return;
        }
        RWUtil.removeStandby(connection);
        connection.do_reconnect();
        connection.rwInfo.cleanup();
        connection.rwInfo.rwCounter = RWCounter.getInstance(connection, connection.standbyCount);
        RWUtil.connectStandby(connection);
    }

    public static void recoverStandby(DmdbConnection connection) {
        if (connection.do_isClosed() || RWUtil.isStandbyAlive(connection)) {
            return;
        }
        long ts = System.currentTimeMillis();
        int freq = connection.rwStandbyRecoverTime;
        if (freq <= 0 || ts - connection.rwInfo.tryRecoverTs < (long)freq) {
            return;
        }
        RWUtil.connectStandby(connection);
        if (!RWUtil.checkStatusValid(connection)) {
            RWUtil.removeStandby(connection);
            log.debug((Object)connection, "recoverStandby", "standby status invalid");
        }
        connection.rwInfo.tryRecoverTs = ts;
    }

    private static void connectStandby(DmdbConnection connection) {
        if (StringUtil.isEmpty(connection.standbyHost) || connection.standbyPort <= 0) {
            log.warn(connection, "connStandby", "no standby");
            return;
        }
        try {
            DmProperties standbyProps = (DmProperties)connection.props.clone();
            standbyProps.setProperty(Configuration.host.getName(), connection.standbyHost);
            standbyProps.setProperty(Configuration.port.getName(), String.valueOf(connection.standbyPort));
            standbyProps.setProperty(Configuration.rwStandby.getName(), String.valueOf(true));
            standbyProps.setProperty(Configuration.epGroup.getName(), null);
            standbyProps.setProperty(Configuration.loginMode.getName(), String.valueOf(2));
            standbyProps.setProperty(Configuration.switchTimes.getName(), "1");
            connection.rwInfo.connStandby = DmDriver.driver.do_connect(standbyProps);
        }
        catch (Throwable ignore) {
            log.warn(connection, "connStandby", ignore.getMessage());
        }
    }

    private static boolean checkStatusValid(DmdbConnection primary) {
        block8: {
            DmdbResultSet srs;
            DmdbStatement sstmt;
            DmdbResultSet prs;
            DmdbStatement pstmt;
            block7: {
                DmdbConnection standby = primary.rwInfo.connStandby;
                if (standby == null || standby.do_isClosed()) {
                    return false;
                }
                if (standby.svrMode != 2 || standby.svrStat != 4) {
                    return false;
                }
                pstmt = null;
                prs = null;
                sstmt = null;
                srs = null;
                int oguidPrimary = 0;
                try {
                    pstmt = primary.do_createStatement();
                    prs = pstmt.do_executeQuery("select oguid from v$instance");
                    prs.do_next();
                    oguidPrimary = prs.do_getInt(1);
                    sstmt = standby.do_createStatement();
                    srs = sstmt.do_executeQuery("select oguid from v$instance");
                    srs.do_next();
                    if (oguidPrimary != srs.do_getInt(1)) break block7;
                    MiscUtil.close(prs);
                }
                catch (Exception exception) {
                    break block8;
                }
                finally {
                    MiscUtil.close(prs);
                    MiscUtil.close(srs);
                    MiscUtil.close(pstmt);
                    MiscUtil.close(sstmt);
                }
                MiscUtil.close(srs);
                MiscUtil.close(pstmt);
                MiscUtil.close(sstmt);
                return true;
            }
            MiscUtil.close(prs);
            MiscUtil.close(srs);
            MiscUtil.close(pstmt);
            MiscUtil.close(sstmt);
        }
        return false;
    }

    public static void afterExceptionOnStandby(DmdbConnection connection, SQLException e2) {
        if (e2.getErrorCode() == DBError.ECJDBC_COMMUNITION_ERROR.errCode) {
            RWUtil.removeStandby(connection);
        }
    }

    private static void removeStandby(DmdbConnection connection) {
        try {
            if (connection.rwInfo.connStandby != null) {
                connection.rwInfo.connStandby.do_close();
                connection.rwInfo.connStandby = null;
            }
        }
        catch (Throwable throwable) {}
    }

    public static boolean isCreateStandbyStmt(DmdbStatement stmt) {
        return stmt != null && stmt.rwInfo.readOnly && RWUtil.isStandbyAlive(stmt.connection);
    }

    public static <T> T execute(DmdbStatement stmt, String sql, ExecuteCallBack<T> callback) throws SQLException {
        DmdbStatement orgStmt = stmt.rwInfo.stmtCurrent;
        RWUtil.recoverStandby(stmt.connection);
        RWUtil.distribute(stmt, sql);
        if (orgStmt != stmt.rwInfo.stmtCurrent) {
            stmt.rwInfo.stmtCurrent.resetParams(orgStmt);
        }
        T ret = null;
        boolean turnToPrimary = false;
        try {
            ret = callback.execute();
            DmdbStatement curStmt = stmt.rwInfo.stmtCurrent;
            switch (curStmt.getRetType()) {
                case 147: 
                case 148: 
                case 151: 
                case 153: 
                case 165: 
                case 166: {
                    try {
                        DmdbStatement otherStmt;
                        DmdbStatement dmdbStatement = otherStmt = curStmt != stmt ? stmt : stmt.rwInfo.stmtStandby;
                        if (otherStmt == null) break;
                        otherStmt.resetParams(curStmt);
                        callback.execute(otherStmt);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 162: {
                    String tmpsql = StringUtil.isNotEmpty(sql) ? sql.trim() : (StringUtil.isNotEmpty(stmt.nativeSql) ? stmt.nativeSql.trim() : "");
                    String sqlhead = tmpsql.split("[ (]", 2)[0];
                    if (sqlhead.equalsIgnoreCase("SP_SET_PARA_VALUE") || sqlhead.equalsIgnoreCase("SP_SET_SESSION_READONLY")) {
                        try {
                            DmdbStatement otherStmt;
                            DmdbStatement dmdbStatement = otherStmt = curStmt != stmt ? stmt : stmt.rwInfo.stmtStandby;
                            if (otherStmt == null) break;
                            otherStmt.resetParams(curStmt);
                            callback.execute(otherStmt);
                        }
                        catch (Exception exception) {}
                    }
                    break;
                }
                case 160: {
                    if (stmt.connection.rwHA && curStmt == stmt.rwInfo.stmtStandby && (curStmt.execInfo.rsDatas == null || curStmt.execInfo.rsDatas.length == 0)) {
                        turnToPrimary = true;
                    }
                    break;
                }
            }
        }
        catch (SQLException e2) {
            if (stmt.rwInfo.stmtCurrent == stmt.rwInfo.stmtStandby) {
                RWUtil.afterExceptionOnStandby(stmt.connection, e2);
                turnToPrimary = true;
            }
            throw e2;
        }
        if (turnToPrimary) {
            stmt.connection.rwInfo.toPrimary();
            stmt.rwInfo.stmtCurrent = stmt;
            stmt.resetParams(stmt.rwInfo.stmtStandby);
            return callback.execute(stmt);
        }
        return ret;
    }

    public static boolean checkReadonly(DmdbStatement stmt, String sql) {
        boolean readonly = true;
        if (StringUtil.isNotEmpty(sql) && !stmt.connection.rwIgnoreSql) {
            String tmpsql = sql.trim();
            String sqlhead = tmpsql.split(" ", 2)[0];
            readonly = sqlhead.equalsIgnoreCase("SELECT") ? stmt.resultSetConcurrency == 1007 : !sqlhead.equalsIgnoreCase("INSERT") && !sqlhead.equalsIgnoreCase("UPDATE") && !sqlhead.equalsIgnoreCase("DELETE") && !sqlhead.equalsIgnoreCase("CREATE") && !sqlhead.equalsIgnoreCase("TRUNCATE") && !sqlhead.equalsIgnoreCase("DROP") && !sqlhead.equalsIgnoreCase("ALTER");
        }
        return readonly;
    }

    public static RWSite distribute(DmdbStatement stmt, String sql) {
        RWSite dest = null;
        if (!RWUtil.isStandbyAlive(stmt.connection)) {
            dest = stmt.connection.rwInfo.toPrimary();
        } else if (stmt instanceof DmdbPreparedStatement ? !stmt.rwInfo.readOnly : !RWUtil.checkReadonly(stmt, sql)) {
            dest = stmt.connection.rwInfo.toPrimary();
        } else if (stmt.connection.rwInfo.distribute == RWSite.PRIMARY && !stmt.connection.getTransFinish() || stmt.connection.rwInfo.distribute == RWSite.STANDBY && !stmt.connection.rwInfo.connStandby.getTransFinish()) {
            dest = stmt.connection.rwInfo.distribute;
        } else if (!stmt.connection.rwAutoDistribute) {
            log.debug((Object)stmt.connection, "distribute", "to Primary because rwAutoDistribute=0 and readOnly=" + stmt.connection.readOnly);
            dest = stmt.connection.readOnly ? stmt.connection.rwInfo.toStandby() : stmt.connection.rwInfo.toPrimary();
        } else {
            dest = stmt.connection.isoLevel != 8 ? stmt.connection.rwInfo.toAny() : stmt.connection.rwInfo.toPrimary();
        }
        if (dest == RWSite.STANDBY && !RWUtil.isStandbyStatementValid(stmt)) {
            try {
                stmt.rwInfo.stmtStandby = stmt instanceof DmdbCallableStatement ? stmt.connection.rwInfo.connStandby.do_prepareCall(stmt.nativeSql, stmt.resultSetType, stmt.resultSetConcurrency, stmt.resultSetHoldability) : (stmt instanceof DmdbPreparedStatement ? stmt.connection.rwInfo.connStandby.do_prepareStatement(stmt.nativeSql, stmt.resultSetType, stmt.resultSetConcurrency, stmt.resultSetHoldability) : stmt.connection.rwInfo.connStandby.do_createStatement(stmt.resultSetType, stmt.resultSetConcurrency, stmt.resultSetHoldability));
            }
            catch (Exception exception) {
                dest = stmt.connection.rwInfo.toPrimary();
            }
        }
        stmt.rwInfo.stmtCurrent = dest == RWSite.PRIMARY ? stmt : stmt.rwInfo.stmtStandby;
        return dest;
    }

    public static boolean isStandbyAlive(DmdbConnection connection) {
        return connection.rwInfo.connStandby != null && !connection.rwInfo.connStandby.do_isClosed();
    }

    public static boolean isStandbyStatementValid(DmdbStatement statement) {
        return statement.rwInfo.stmtStandby != null && !statement.rwInfo.stmtStandby.do_isClosed();
    }
}

